CREATE DATABASE ZamowieniaPrzyklad
GO

use ZamowieniaPrzyklad
GO

CREATE TABLE Kategorie (
	IDKategorii int NOT NULL ,
	OpisKategorii nvarchar (75) NULL 
)
GO

CREATE TABLE Klienci (
	IDKlienta int NOT NULL ,
	ImieKlienta nvarchar (25) NULL ,
	NazwiskoKlienta nvarchar (25) NULL ,
	AdresKlienta nvarchar (50) NULL ,
	MiastoKlienta nvarchar (30) NULL ,
	StanZamKlienta nvarchar (2) NULL ,
	KodPocztowyKlienta nvarchar (10) NULL ,
	NumKierKlienta smallint NULL ,
	TelefonKlienta nvarchar (8) NULL 
)
GO

CREATE TABLE Pracownicy (
	IDPracownika int NOT NULL ,
	ImiePracownika nvarchar (25) NULL ,
	NazwiskoPracownika nvarchar (25) NULL ,
	AdresPracownika nvarchar (50) NULL ,
	MiastoPracownika nvarchar (30) NULL ,
	StanZamPracownika nvarchar (2) NULL ,
	KodPocztowyPracownika nvarchar (10) NULL ,
	NumKierunkPracownika smallint NULL ,
	TelefonPracownika nvarchar (8) NULL , 
        DataUrodzPracownika date NULL
)
GO

CREATE TABLE Dane_zamowien (
	NumerZamowienia int NOT NULL ,
	NumerProduktu int NOT NULL ,
	CenaZakupu money NULL ,
	ZamowionaIlosc smallint NULL 
)
GO

CREATE TABLE Zamowienia (
	NumerZamowienia int NOT NULL ,
	DataZamowienia date NULL ,
	DataWysylki date NULL ,
	IDKlienta int NULL ,
	IDPracownika int NULL 
)
GO

CREATE TABLE Dostawcy_produktow (
	NumerProduktu int NOT NULL ,
	IDDostawcy int NOT NULL ,
	CenaHurtowa money NULL ,
	TerminDostarczenia smallint NULL 
)
GO

CREATE TABLE Produkty (
	NumerProduktu int NOT NULL ,
	NazwaProduktu nvarchar (50) NULL ,
	OpisProduktu nvarchar (100) NULL ,
	CenaDetaliczna money NULL ,
	StanMagazynowy smallint NULL ,
	IDKategorii int NULL 
)
GO

CREATE TABLE Dostawcy (
	IDDostawcy int NOT NULL ,
	NazwaDostawcy nvarchar (25) NULL ,
	AdresDostawcy nvarchar (50) NULL ,
	MiastoDostawcy nvarchar (30) NULL ,
	StanSiedzDostawcy nvarchar (2) NULL ,
	KodPocztowyDostawcy nvarchar (10) NULL ,
	TelefonDostawcy nvarchar (15) NULL ,
	FaxDostawcy nvarchar (15) NULL ,
	StronaInterDostawcy ntext NULL ,
	EmailDostawcy nvarchar (50) NULL 
) 
GO

CREATE TABLE ztblMiesiace (
	MiesiacRok nvarchar (20) NOT NULL ,
        NumerRoku smallint NOT NULL ,
        NumerMiesiaca smallint NOT NULL ,
        PoczatekMiesiaca date NOT NULL ,
        KoniecMiesiaca date NOT NULL ,
        Styczen smallint NOT NULL ,
        Luty smallint NOT NULL ,
        Marzec smallint NOT NULL ,
        Kwiecien smallint NOT NULL ,
        Maj smallint NOT NULL ,
        Czerwiec smallint NOT NULL ,
        Lipiec smallint NOT NULL ,
        Sierpien smallint NOT NULL ,
        Wrzesien smallint NOT NULL ,
        Pazdziernik smallint NOT NULL ,
        Listopad smallint NOT NULL ,
        Grudzien smallint NOT NULL 
) 
GO

CREATE TABLE ztblZakresyCen ( 
        KategoriaCenowa nvarchar (20) NOT NULL ,
        ProgDolny money NULL ,
        ProgGorny money NULL
)
GO

CREATE TABLE ztblKuponyZakupowe (
        ProgDolnyZakupu money NOT NULL ,
        ProgGornyZakupu money NULL ,
        LiczbaKuponow smallint NULL 
)
GO

CREATE TABLE ztblNumeryKolejne (
        Kolejnosc int NOT NULL 
)
GO

ALTER TABLE Kategorie ADD 
	CONSTRAINT Category_ID_Default DEFAULT (0) FOR IDKategorii,
	CONSTRAINT Kategorie_PK PRIMARY KEY   
	(
		IDKategorii
	)  
GO

 CREATE  INDEX IDKategorii ON Kategorie(IDKategorii)
GO

ALTER TABLE Klienci ADD 
	CONSTRAINT Cust_Area_Code_Default DEFAULT (0) FOR NumKierKlienta,
	CONSTRAINT Klienci_PK PRIMARY KEY   
	(
		IDKlienta
	)  
GO

 CREATE  INDEX NumKierKlienta ON Klienci(NumKierKlienta)
GO

 CREATE  INDEX KodPocztowyKlienta ON Klienci(KodPocztowyKlienta)
GO

ALTER TABLE Pracownicy ADD 
	CONSTRAINT Emp_Area_Code_Default DEFAULT (0) FOR NumKierunkPracownika,
	CONSTRAINT Pracownicy_PK PRIMARY KEY   
	(
		IDPracownika
	)  
GO

 CREATE  INDEX NumKierunkPracownika ON Pracownicy(NumKierunkPracownika)
GO

 CREATE  INDEX KodPocztowyPracownika ON Pracownicy(KodPocztowyPracownika)
GO

ALTER TABLE Dane_zamowien ADD 
	CONSTRAINT OD_Order_Number_Default DEFAULT (0) FOR NumerZamowienia,
	CONSTRAINT OD_Product_Number_Default DEFAULT (0) FOR NumerProduktu,
	CONSTRAINT Quoted_Price_Default DEFAULT (0) FOR CenaZakupu,
	CONSTRAINT Quantity_Ordered_Default DEFAULT (0) FOR ZamowionaIlosc,
	CONSTRAINT Dane_zamowien_PK PRIMARY KEY   
	(
		NumerZamowienia,
		NumerProduktu
	)  
GO

 CREATE  INDEX ZamowieniaOrderDetails ON Dane_zamowien(NumerZamowienia)
GO

 CREATE  INDEX ProduktyOrderDetails ON Dane_zamowien(NumerProduktu)
GO

ALTER TABLE Zamowienia ADD 
	CONSTRAINT Order_Number_Default DEFAULT (0) FOR NumerZamowienia,
	CONSTRAINT O_Customer_ID_Default DEFAULT (0) FOR IDKlienta,
	CONSTRAINT O_Employee_ID_Default DEFAULT (0) FOR IDPracownika,
	CONSTRAINT Zamowienia_PK PRIMARY KEY   
	(
		NumerZamowienia
	)  
GO

 CREATE  INDEX IDKlienta ON Zamowienia(IDKlienta)
GO

 CREATE  INDEX IDPracownika ON Zamowienia(IDPracownika)
GO

ALTER TABLE Dostawcy_produktow ADD 
	CONSTRAINT PV_Product_Number_Default DEFAULT (0) FOR NumerProduktu,
	CONSTRAINT PV_Vendor_ID_Default DEFAULT (0) FOR IDDostawcy,
	CONSTRAINT Wholesale_Price_Default DEFAULT (0) FOR CenaHurtowa,
	CONSTRAINT Days_To_Deliver_Default DEFAULT (0) FOR TerminDostarczenia,
	CONSTRAINT Dostawcy_produktow_PK PRIMARY KEY   
	(
		NumerProduktu,
		IDDostawcy
	)  
GO

 CREATE  INDEX ProduktyProductDostawcy ON Dostawcy_produktow(NumerProduktu)
GO

 CREATE  INDEX IDDostawcy ON Dostawcy_produktow(IDDostawcy)
GO

ALTER TABLE Produkty ADD 
	CONSTRAINT Product_Number_Default DEFAULT (0) FOR NumerProduktu,
	CONSTRAINT Retail_Price_Default DEFAULT (0) FOR CenaDetaliczna,
	CONSTRAINT Quantitiy_On_Hand_Default DEFAULT (0) FOR StanMagazynowy,
	CONSTRAINT P_Product_ID_Default DEFAULT (0) FOR IDKategorii,
	CONSTRAINT Produkty_PK PRIMARY KEY   
	(
		NumerProduktu
	)  
GO

 CREATE  INDEX KategorieProdukty ON Produkty(IDKategorii)
GO

ALTER TABLE Dostawcy ADD 
	CONSTRAINT Dostawcy_PK PRIMARY KEY   
	(
		IDDostawcy
	)  
GO

 CREATE  INDEX KodPocztowyDostawcy ON Dostawcy(KodPocztowyDostawcy)
GO

ALTER TABLE ztblMiesiace ADD
        CONSTRAINT Styczen_Default DEFAULT (0) FOR Styczen,
        CONSTRAINT Luty_Default DEFAULT (0) FOR Luty,
        CONSTRAINT Marzec_Default DEFAULT (0) FOR Marzec,
        CONSTRAINT Kwiecien_Default DEFAULT (0) FOR Kwiecien, 
        CONSTRAINT May_Default DEFAULT (0) FOR Maj, 
        CONSTRAINT June_Default DEFAULT (0) FOR Czerwiec, 
        CONSTRAINT July_Default DEFAULT (0) FOR Lipiec, 
        CONSTRAINT August_Default DEFAULT (0) FOR Sierpien, 
        CONSTRAINT September_Default DEFAULT (0) FOR Wrzesien, 
        CONSTRAINT October_Default DEFAULT (0) FOR Pazdziernik, 
        CONSTRAINT November_Default DEFAULT (0) FOR Listopad, 
        CONSTRAINT December_Default DEFAULT (0) FOR Grudzien, 
 	CONSTRAINT ztblMiesiace_PK PRIMARY KEY 
	(
		NumerRoku, 
                NumerMiesiaca
	)
GO

 CREATE  UNIQUE INDEX Miesiac_koniec ON ztblMiesiace(KoniecMiesiaca)
GO

 CREATE  UNIQUE INDEX Miesiac_poczatek ON ztblMiesiace(PoczatekMiesiaca)
GO

 CREATE  UNIQUE INDEX Miesiac_rok ON ztblMiesiace(MiesiacRok)
GO

ALTER TABLE ztblZakresyCen ADD 
	CONSTRAINT ztblZakresyCen_PK PRIMARY KEY 
	(
		KategoriaCenowa 
	)
GO

ALTER TABLE ztblKuponyZakupowe ADD 
	CONSTRAINT NumCoupons_Default DEFAULT (0) FOR LiczbaKuponow, 
	CONSTRAINT ztblKuponyZakupowe_PK PRIMARY KEY 
	( 
		ProgDolnyZakupu
	)
GO

 CREATE  INDEX Num_Coupons ON ztblKuponyZakupowe(LiczbaKuponow)
GO

ALTER TABLE ztblNumeryKolejne ADD 
	CONSTRAINT Sequence_Default DEFAULT (0) FOR Kolejnosc, 
        CONSTRAINT ztblNumeryKolejne_PK PRIMARY KEY
        (
                Kolejnosc
        )
GO

ALTER TABLE Dane_zamowien ADD 
	CONSTRAINT Dane_zamowien_FK00 FOREIGN KEY 
	(
		NumerZamowienia
	) REFERENCES Zamowienia (
		NumerZamowienia
	),
	CONSTRAINT Dane_zamowien_FK01 FOREIGN KEY 
	(
		NumerProduktu
	) REFERENCES Produkty (
		NumerProduktu
	)
GO

ALTER TABLE Zamowienia ADD 
	CONSTRAINT Zamowienia_FK00 FOREIGN KEY 
	(
		IDKlienta
	) REFERENCES Klienci (
		IDKlienta
	),
	CONSTRAINT Zamowienia_FK01 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Pracownicy (
		IDPracownika
	)
GO

ALTER TABLE Dostawcy_produktow ADD 
	CONSTRAINT Dostawcy_produktow_FK00 FOREIGN KEY 
	(
		NumerProduktu
	) REFERENCES Produkty (
		NumerProduktu
	),
	CONSTRAINT Dostawcy_produktow_FK01 FOREIGN KEY 
	(
		IDDostawcy
	) REFERENCES Dostawcy (
		IDDostawcy
	)
GO

ALTER TABLE Produkty ADD 
	CONSTRAINT Produkty_FK00 FOREIGN KEY 
	(
		IDKategorii
	) REFERENCES Kategorie (
		IDKategorii
	)
GO

